package examples.stateful;

import javax.annotation.Resource;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;

import examples.stateful.interfaces.Cart;

@Stateful
public class CartBean implements Cart {
	@Resource SessionContext context;
	private int numItems;
	
	public void addItem() {
		numItems++;
	}
	
	public int getItems() {
		return numItems;
	}
	
	@Remove(retainIfException=false)
	public void remove1() throws Exception {
		doRemove();
	}
	
	@Remove(retainIfException=true)
	public void remove2() throws Exception {
		doRemove();
	}
	
	private void doRemove() throws Exception {
		if (numItems > 1 && numItems < 4) {
			throw new Exception("blah");
		}
		System.out.println("Removing cart with: "+numItems+" items.");
	}
}
